# BizVektor 設定＆カスタマイズガイド

- - -

## クイックスタートで簡単構築

簡単にウェブサイトの雛形が出来るように解説したページとインポート用のデータが公式サイトに用意されています。

[ <a href="http://bizvektor.com/setting/quick-start/" target="_blank">→ BizVektorクイックスタート</a> ]

- - -

## メニューの設定

メニューの設定について、ヘッダーメニューの数がやたら多いサイトや、フッターメニューエリアにヘッダーメニューと全く同じ項目を設定しているサイトなどをよく見かけます。
メニューの設定方法や考え方については公式サイトで解説していますので参考にしてください。

[ <a href="http://bizvektor.com/setting/bizvektorsetting/menu/" target="_blank">→ メニューの設定</a> ]

- - -

## CSSを修正して見た目をカスタマイズする

### 管理画面からCSSをカスタマイズする方法

BizVektorでは、管理画面の __「外観」→「CSSカスタマイズ」画面__ より、CSSを記述するとそのまま変更出来るようになっています。  
（テーマを直接編集してしまうとバージョンアップで消えてしまうため）  
CSS カスタマイズ画面には需要の高い例文がいくつか掲載されていますので、貼り付けて確認してみてください。

### デザインをカスタマイズしたい場所のCSSセレクタの探し方

#### セレクタとは 

CSSでデザインを修正する対象をセレクタと呼びます。  
例えば下記のHTMLで、 h1の『投稿のタイトル』の部分を修正する場合

~~~
<div id="content" class="content">
<h1 class="entryPostTitle">投稿のタイトル</h1>
</div>
~~~

CSSのセレクタは

~~~
#content h1.entryPostTitle { font-size:18px; }
~~~

のようになります。
idの場合は # が先頭につき、classの場合は . が先頭につきます。

『#』がつくセレクタの指定は優先度が高く、

たとえば

~~~
h1 { font-size:50px; }
~~~

と指定しても、元々のCSSに

~~~
#content h1.entryPostTitle { font-size:18px; }
~~~

と書かれていた場合は #content が付いている方の指定が優先されてしまいますので、思い通りに効かない場合はセレクタを確認してみましょう。

#### デベロッパーツールの活用

特定の部分だけCSSを修正したい場合、テーマ内のCSSから該当箇所を探し出すのはとても大変です。
そんな時はブラウザのデベロッパーツールを活用します。

<dl>
<dt>Google Chrome</dt>
<dd>Windowsの場合 : [ F12 ]　／ Macの場合 ： [ command ] + [ option ] + [ i ] </dd>
</dl>

1. デベロッパーツールを開いて左上の虫眼鏡アイコンをクリック
1. 画面上の変更したい要素を選択
1. デベロッパーツールのstyleタブに適用されているcssとそのセレクタが表示される  
この時、直接数値を変更したりして確認も出来ます。
1. 該当の部分のセレクタとCSSの指定を「CSSカスタマイズ」画面に貼り付けます。

#### レスポンシブ対応時の注意

デベロッパーツールでセレクタを確認した際に、

~~~
@media (min-width: 970px)
~~~

などの表示がある場合は注意が必要です。
上記の場合は ブラウザのサイズが970px以上の時だけ有効になる指定です。

同じように 970px　以上の時だけ指定したい場合は

~~~
@media (min-width: 970px) {
#content h1.entryPostTitle { font-size:18px; }
}
~~~

というように記述します。


- - -

## バージョンアップに影響されない修正方法（子テーマの設定）

### テーマファイルは直接修正しない

テーマを直接編集してしまうと __バージョンアップの時に消えてしまします__  

修正した部分だけを新しいバージョンに反映させようとしても、
__沢山カスタマイズすればするほど面倒__ になる上、
そもそも、 __どこを変更したのかわからない__ 状態になってしまいます。

そんな時に便利なのが __子テーマ__ です。

### 子テーマとは

カスタマイズしたいテーマを親テーマとして、変更したいファイルだけを子テーマのフォルダに複製すると、そのファイルだけは優先して使用される機能です。
子テーマにあるファイル以外は親テーマのファイルが呼び出されます。

### 子テーマの作り方

通常は /wp-content/themes/ ディレクトリの中に子テーマ用のディレクトリを設置し、テーマの情報を記述した style.cssをアップします。
ただ、子テーマの最小限のファイルセットを下記からダウンロードする事ができます。

[ <a href="http://bizvektor.com/setting/customize/" target="_blank">高度なカスタマイズの仕様（子テーマサンプルファイルのダウンロード）</a> ]

たとえば、写真と抜粋付きの一覧表示の所で、「この記事を読む」ボタンを削除したい場合は

/wp-content/themes/biz-vektor/ ディレクトリ内の module_loop_post2.php を子テーマのフォルダに複製して、26行目あたりの下記の行を削除します。

~~~
<div class="moreLink"><a href="<?php the_permalink(); ?>"><?php _e('Read more', 'biz-vektor'); ?></a></div>
~~~

* ファイル上では 'Read more' と書かれていますが、予め用意されている翻訳ファイルを経由して、「この記事を読む」という文字に変換して表示されます。
* 通常のBizVektorから子テーマに切り替えると、WordPressからは「テーマを変更した」とみなされるので、メニューやウィジェットのセットなどは解除されます。  
後でいろいろカスタマイズするのであれば最初から子テーマを作っておくと良いでしょう。

- - -

## ヘッダーの電話番号まわりのカスタマイズ

~~~
<?php // ← 既にfunctions.php が存在し、もともと書いてある場合は不要
add_filter('headContactCustom','do_head_contact_custom');
function do_head_contact_custom($headContact){
    $headContact =  '<div id="headContact"><div id="headContactInner">バナーのイメージタグ</div></div>';
    return $headContact;
}
~~~

もう少し詳しい情報が公式サイトに記載してあります。

[ <a href="http://bizvektor.com/setting/customize/headcontactcustom/" target="_blank">→ ヘッダーの電話番号周りのカスタマイズ方法</a> ] 


- - -

## 最小限の作業でカスタム投稿タイプを使う方法

### カスタム投稿タイプとは

WordPressでは、標準で「投稿」と「固定ページ」という投稿タイプが存在します。
BizVektorではこれに加えて「お知らせ（info）」という投稿タイプが独自に追加してあります。

ある程度規模の大きなサイトを作る場合、たとえば「実績紹介」であったり「製品紹介」など、更に投稿タイプを増やして運用したりします。

その場合、普通は増やした投稿タイプ用のテンプレートを作成する必要があるのですが、BizVektorではそれらの作業が極めて少なくてすむように作られています。

### カスタム投稿タイプの作成

カスタム投稿タイプの作成方法について詳しくは割愛しますが、
子テーマのfunctions.phpに下記のように記述します。

~~~
/*-------------------------------------------*/
/*	カスタム投稿タイプ「イベント情報」を追加
/*-------------------------------------------*/
add_action( 'init', 'add_post_type_event', 0 );
function add_post_type_event() {
	register_post_type( 'event', // カスタム投稿タイプのスラッグ
		array(
			'labels' => array(
				'name' => 'イベント情報',
				'singular_name' => 'イベント情報'
			),
		'public' => true,
		'menu_position' =>5,
		'has_archive' => true,
		'supports' => array('title','editor','excerpt','thumbnail','author')
		)
	);
}
~~~

上記のコードでは、投稿タイプ『イベント情報』を作成していますが、『イベント情報』の投稿タイプのスラッグ（識別子）は『event』としています。

### カスタム分類の作成

投稿の「カテゴリー」のように、カスタム分類にもカテゴリーを追加する事ができます。

~~~
/*-------------------------------------------*/
/*	カスタム分類「イベント情報カテゴリー」を追加
/*-------------------------------------------*/
add_action( 'init', 'add_custom_taxonomy_event', 0 );
function add_custom_taxonomy_event() {
	register_taxonomy(
		'event-cat', // カテゴリーの識別子
		'event', // 対象の投稿タイプ
		array(
			'hierarchical' => true,
			'update_count_callback' => '_update_post_term_count',
			'label' => 'イベントカテゴリー',
			'singular_label' => 'イベント情報カテゴリー',
			'public' => true,
			'show_ui' => true,
		)
	);
}
~~~




### カスタム投稿タイプ用のウィジェットエリアを作成する

★★ BizVektor 1.9.0 からは投稿タイプが追加されたら自動的にウィジェットエリアが生成されるので、下記の記述は不要になりました。

イベント情報・イベント情報カテゴリーを作成したら、サイドバーには

* イベント情報のカテゴリー
* 月別アーカイブページへのリンクメニュー
* イベント情報関連のページだけ表示するバナーなど

が欲しい所です。

『イベント情報』のサイドバー用のウィジェットエリアを作成しましょう。

下記のコードを functions.php に追加します。

~~~
/*-------------------------------------------*/
/*	カスタム投稿タイプのウィジェットエリアを追加
/*-------------------------------------------*/
function biz_vektor_event_widgets_init() {
	register_sidebar( array(
		'name' => 'サイドバー（イベント情報）',
		/***************************/
		'id' => 'event-widget-area',
		/***************************/
		'description' => 'イベント情報で表示されるウィジェットエリアです',
		'before_widget' => '<div class="widget %2$s sideWidget" id="%1$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="localHead">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'biz_vektor_event_widgets_init' );
~~~

ポイントは **** で挟んでいる id　の部分です。  
id の値が 

~~~
投稿スラッグ名-widget-area
~~~

となるように設定します。
この形式でウィジェットエリアを設定すると、BizVektorでは投稿タイプのスラッグが『event』の関連ページの時に、このウィジェットエリアにセットしたアイテムが自動的に表示されます。

### カスタム投稿タイプ用のウィジェットの設定

#### イベント情報のカテゴリー一覧をサイドバーに表示する

BizVektorではカスタム分類の一覧用のウィジェットが最初から用意されています。  
__BV_カテゴリー／カスタム分類リスト__ のウィジェットを、ウィジェットエリア『サイドバー（イベント情報）』にセットします。

#### イベント情報の年別／月別アーカイブページへのリンクをサイドバーに表示する

カスタム分類同様に、年別や月別アーカイブページへのリンクを表示するウィジェットも用意されています。  
__BV_アーカイブリストウィジェット__ をセットして、どの投稿タイプを選択（この場合はevent）として、年別か月別かを選択します。

### サイドバーを丸ごとカスタマイズしたい場合

ウィジェットで概ね対応出来るとは思いますが、もっと大きなカスタマイズがしたい場合は、
__sidebar-投稿タイプスラッグ.php__ という名前のファイルを子テーマフォルダに用意すれば、そのファイルが呼び出されます。

### カスタム投稿タイプの一覧だけカスタマイズする

アーカイブページで、繰り返し表示される投稿の表示要素のレイアウトを変更したい場合は、
__module_loop_投稿タイプスラッグ.php__ という名前のファイルを子テーマフォルダに用意すれば、そのファイルが呼び出されます。
biz-vektor ディレクトリの module_loop_post2.php などを複製して module_loop_event.php と変更して、それを編集するとやりやすいかと思います。



## 自分用のデザインスキンを作る

オリジナルのデザインスキンを作りたい場合は、下記のページを参照ください。
http://bizvektor.com/setting/customize/


